import React from 'react';
import { render } from 'react-dom';
import MediaUnit from '../components/media-unit';
import { MediaItem } from '../types/media';
import { addClass } from '../lib/dom';

export default (ctx: HTMLElement) => {
  const units = ctx.querySelectorAll('.js-media-unit');
  [].forEach.call(units, (unit: HTMLElement) => {
    if (!unit) {
      return;
    }
    addClass(unit, 'done');
    const id = unit.dataset.id;
    const { primaryImageId, rootDir, mediaSizes, bid, diff, 
      mediaDir, active, enlarged, primary, thumbnail, type,
      caption, text, alt, mid, link, landscape, lang, name
    } = unit.dataset;
    const thumbnailPath = type === 'file' ? `${rootDir}${thumbnail}` : `${mediaDir}${thumbnail}`
    const item = {
      media_caption: caption,
      media_text: text,
      media_alt: alt,
      media_id: mid,
      media_link: link,
      media_landscape: landscape,
      media_thumbnail: thumbnailPath,
      media_type: type,
      media_title: name
    } as MediaItem;
    let mediaSizesFiltered = [];
    if (mediaSizes) {
      mediaSizesFiltered = JSON.parse(mediaSizes).filter((item: object) => {
        if (Object.keys(item).length === 0) {
          return false;
        }
        return true;
      })
    }
    render(<MediaUnit 
      items={[item]} 
      id={id} 
      primaryImageId={primaryImageId} 
      mediaSizes={mediaSizesFiltered}
      mediaDir={mediaDir} 
      rootDir={rootDir}
      bid={bid}
      diff={diff}
      active={active}
      primary={primary}
      lang={lang}
      enlarged={enlarged}
    />, 
    unit);
  });
};
