const pkg = require('./package.json');
const merge = require('webpack-merge');
const common = require('./webpack.common.js');

process.env.BABEL_ENV = 'development';

module.exports = merge(common, {
  mode: 'development',
  devtool: 'inline-source-map',
  devServer: {
    open: true,
    openPage: '',
    inline: true,
    hot: false,
    // contentBase: `${__dirname}/dest`,
    publicPath: `/themes/${pkg.config.theme}/dest/`,
    watchContentBase: true,
    port: 3000,
    proxy: {
      '**': {
        target: {
          host: pkg.config.local,
          protocol: 'http:',
          port: 80
        },
        secure: false,
        changeOrigin: true
      }
    }
  }
});
