// ページ上部へ戻るボタンの表示の設定
$(function () {
    const $nav = $('.page-top-btn');
    const offset  = '50';
    const footer  = $(document).height() - $(window).height() - 500;
    $(window).scroll(function() {
        if($(window).scrollTop() > offset) {
            $nav.addClass('page-top-btn-appear');
        } else {
            $nav.removeClass('page-top-btn-appear');
        }
    });

  $.fn.delayAddClass = function (className, delay) {
    return $(this).delay(delay).queue(function (next) {
      $(this).addClass(className);
      next();
    });
  };
  $.fn.delayRemoveClass = function (className, delay) {
    return $(this).delay(delay).queue(function (next) {
      $(this).removeClass(className);
      next();
    });
  };

    const $mobileNavTrigger = $('.js-mobile-nav-btn');
    const $mobileNavContents = $('.js-mobile-nav');
    $($mobileNavTrigger).click(function(){
      $('body').toggleClass('is-locked');
      const $mobileNavAttr = $($mobileNavTrigger).attr('aria-expanded');
      if ($mobileNavAttr === 'true') {
        $($mobileNavTrigger).attr('aria-expanded', false);
        $($mobileNavContents).delayRemoveClass('is-opened', 1).delayRemoveClass('is-active', 100);
      } else {
        $($mobileNavTrigger).attr('aria-expanded', true);
        $($mobileNavContents).delayAddClass('is-active', 1).delayAddClass('is-opened', 100);
      }
      $($mobileNavContents).find('[href*="#"]').click(function(){
        $($mobileNavTrigger).attr('aria-expanded', false);
        $($mobileNavContents).delayRemoveClass('is-opened', 1).delayRemoveClass('is-active', 100);
        $('body').removeClass('is-locked');
      });
    });

    // 郵便番号の「-」の挿入
    $('.js-insert-hyphen').blur(function(){
        function insertStr(str, index, insert) {
            return str.slice(0, index) + insert + str.slice(index, str.length);
        }
        const zip = $(this).val();
        if (zip.length > 6 && !zip.match('-')) {
            var zipHyphen = insertStr(zip, 3, '-');
            $(this).val(zipHyphen);
        }
    });
});

// オフキャンバスのブレイクポイントの設定
ACMS.Ready(function(){
    ACMS.Config.offcanvas.breakpoint = 1023;
});
