<?php

class ACMS_GET_Ogp extends ACMS_GET
{
    var $_scope = array(
        'uid' => 'global',
        'cid' => 'global',
        'eid' => 'global',
        'keyword' => 'global',
        'tag' => 'global',
        'date' => 'global',
        'page' => 'global',
    );

    /**
     * @return mixed
     */
    public function get()
    {
        $Tpl = new Template($this->tpl, new ACMS_Corrector());
        $vars = array(
            'title' => $this->getTitle(),
            'image' => $this->getImage(),
            'description' => $this->getDescription(),
            'keywords' => $this->getKeywords(),
            'type' => $this->getType(),
        );

        if ($vars['image']) {
            $size = Storage::getImageSize(ARCHIVES_DIR. $vars['image']);
            if ($size) {
                $vars = array_merge($vars, array (
                    'image@x' => $size[0],
                    'image@y' => $size[1]
                ));
            }
        }

        return $Tpl->render($vars);
    }

    public function getType()
    {
        if (RBID === BID && VIEW === 'top') {
            return 'website';
        } else {
            return 'article';
        }
    }

    /**
     * og:title を取得します
     * @return string
     */
    public function getTitle()
    {
        $config = config('ogp_title_order', 'entry,page,tag,keyword,date,admin,404,category,blog,rootBlog');
        $glue = config('ogp_title_delimiter', ' | ');
        $title = '';

        $parts = preg_split(REGEXP_SEPARATER, $config, -1, PREG_SPLIT_NO_EMPTY);
        $parts = array_unique($parts);

        foreach ($parts as $part) {
            $method = 'get' . ucwords($part) . 'Title';
            if (is_callable(array($this, $method))) {
                if ($val = call_user_func(array($this, $method))) {
                    $title .= ($val . $glue);
                }
            }
        }
        return rtrim($title, $glue);
    }

    /**
     * og:image を取得
     * 優先度: EntryField -> EntryMainImage -> CategoryField -> BlogField
     *
     * @return bool|string
     */
    public function getImage()
    {
        if ($image = $this->getEntryImage()) {
            return $image;
        }
        if ($image = $this->getCategoryImage()) {
            return $image;
        }
        if ($image = $this->getBlogImage(BID)) {
            return $image;
        }
        if ($image = $this->getBlogImage(RBID)) {
            return $image;
        }
        return false;
    }

    /**
     * og:description を取得
     * 優先度: EntryField -> EntrySummary -> CategoryField -> BlogField
     *
     * @return bool|string
     */
    public function getDescription()
    {
        if ($description = $this->getEntryDescription()) {
            return $description;
        }
        if ($description = $this->getCategoryDescription()) {
            return $description;
        }
        if ($description = $this->getBlogDescription(BID)) {
            return $description;
        }
        if ($description = $this->getBlogDescription(RBID)) {
            return $description;
        }
        return false;
    }

    /**
     * keywords を取得
     * 優先度: EntryField -> CategoryField -> BlogField
     *
     * @return bool|string
     */
    public function getKeywords()
    {
        if ($keyword = $this->getEntryKeywords()) {
            return $keyword;
        }
        if ($keyword = $this->getCategoryKeywords()) {
            return $keyword;
        }
        if ($keyword = $this->getBlogKeywords(BID)) {
            return $keyword;
        }
        if ($keyword = $this->getBlogKeywords(RBID)) {
            return $keyword;
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getEntryImage()
    {
        if (!EID) {
            return false;
        }
        $field_name = config('ogp_image_entry_field_name', false);
        if (!empty($field_name)) {
            $field = loadEntryField(EID);
            if ($image = $field->get($field_name . '@path')) {
                return $image;
            }
        }
        if ($primary_img_id = ACMS_RAM::entryPrimaryImage(EID)) {
            if ($unit = ACMS_RAM::unit($primary_img_id)) {
                return $unit['column_field_2'];
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getCategoryImage()
    {
        if (!CID) {
            return false;
        }
        $field_name = config('ogp_image_category_field_name', false);
        if (!empty($field_name)) {
            $field = loadCategoryField(CID);
            if ($image = $field->get($field_name . '@path')) {
                return $image;
            }
        }
        return false;
    }

    /**
     * @param int $bid
     * @return bool|string
     */
    protected function getBlogImage($bid=BID)
    {
        if (empty($bid)) {
            return false;
        }
        $field_name = config('ogp_image_blog_field_name', false);
        if (!empty($field_name)) {
            $field = loadBlogField($bid);
            if ($image = $field->get($field_name . '@path')) {
                return $image;
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getEntryDescription()
    {
        if (!EID) {
            return false;
        }
        $field_name = config('ogp_description_entry_field_name', false);
        if (!empty($field_name)) {
            $field = loadEntryField(EID);
            if ($description = $field->get($field_name)) {
                return $description;
            }
        }
        $vars = array();
        if ($vars = Tpl::buildSummaryFulltext($vars, EID)) {
            if (isset($vars['summary'])) {
                return $vars['summary'];
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getCategoryDescription()
    {
        if (!CID) {
            return false;
        }
        $field_name = config('ogp_description_category_field_name', false);
        if (!empty($field_name)) {
            $field = loadCategoryField(CID);
            if ($description = $field->get($field_name)) {
                return $description;
            }
        }
        return false;
    }

    /**
     * @param int $bid
     * @return bool|string
     */
    protected function getBlogDescription($bid=BID)
    {
        if (empty($bid)) {
            return false;
        }
        $field_name = config('ogp_description_blog_field_name', false);
        if (!empty($field_name)) {
            $field = loadBlogField($bid);
            if ($description = $field->get($field_name)) {
                return $description;
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getEntryKeywords()
    {
        if (!EID) {
            return false;
        }
        $field_name = config('ogp_keywords_entry_field_name', false);
        if (!empty($field_name)) {
            $field = loadEntryField(EID);
            if ($keywords = $field->get($field_name)) {
                return $keywords;
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getCategoryKeywords()
    {
        if (!CID) {
            return false;
        }
        $field_name = config('ogp_keywords_category_field_name', false);
        if (!empty($field_name)) {
            $field = loadCategoryField(CID);
            if ($keywords = $field->get($field_name)) {
                return $keywords;
            }
        }
        return false;
    }

    /**
     * @param int $bid
     * @return bool|string
     */
    protected function getBlogKeywords($bid=BID)
    {
        if (empty($bid)) {
            return false;
        }
        $field_name = config('ogp_keywords_blog_field_name', false);
        if (!empty($field_name)) {
            $field = loadBlogField($bid);
            if ($keywords = $field->get($field_name)) {
                return $keywords;
            }
        }
        return false;
    }

    /**
     * @return bool|string
     */
    protected function getEntryTitle()
    {
        if (!EID) {
            return false;
        }
        $field_name = config('ogp_title_entry_field_name', false);
        if (!empty($field_name)) {
            $field = loadEntryField(EID);
            if ($title = $field->get($field_name)) {
                return $title;
            }
        }
        return ACMS_RAM::entryTitle(EID);
    }

    /**
     * @return bool|string
     */
    protected function getCategoryTitle()
    {
        if (!CID) {
            return false;
        }
        $field_name = config('ogp_title_category_field_name', false);
        if (!empty($field_name)) {
            $field = loadCategoryField(CID);
            if ($title = $field->get($field_name)) {
                return $title;
            }
        }
        return ACMS_RAM::categoryName(CID);
    }

    /**
     * @param int|null $bid
     * @return bool|string
     */
    protected function getBlogTitle($bid = BID)
    {
        if (empty($bid)) {
            return false;
        }
        $field_name = config('ogp_title_blog_field_name', false);
        if (!empty($field_name)) {
            $field = loadBlogField($bid);
            if ($title = $field->get($field_name)) {
                return $title;
            }
        }
        return ACMS_RAM::blogName($bid);
    }

    /**
     * @return bool|string
     */
    protected function getRootBlogTitle()
    {
        $parent = loadAncestorBlog('parent', 'id');
        if (empty($parent)) {
            return false;
        }
        return $this->getBlogTitle(RBID);
    }

    /**
     * @return bool|string
     */
    protected function getPageTitle()
    {
        if (!PAGE || PAGE < 2) {
            return false;
        }
        $suffix = config('ogp_title_page_suffix', '');
        return str_replace('{page}', PAGE, $suffix);
    }

    /**
     * @return bool|string
     */
    protected function getTagTitle()
    {
        if (!TAG) {
            return false;
        }
        $string = '';
        $glue = config('ogp_title_tag_delimiter', '/');
        foreach ($this->tags as $i => $tag) {
            if ($i > 0) {
                $string .= $glue;
            }
            $string .= $tag;
        }
        return $string;
    }

    /**
     * @return bool|null|string
     */
    protected function getKeywordTitle()
    {
        if (!KEYWORD) {
            return false;
        }
        return KEYWORD;
    }

    /**
     * @return bool|false|string
     */
    protected function getDateTitle()
    {
        if (!DATE) {
            return false;
        }
        $format = config('ogp_title_date_format', 'Y-m-d');
        return date($format, strtotime(str_replace('/', '-', DATE)));
    }

    /**
     * @return bool|string
     */
    protected function getAdminTitle()
    {
        if (!ADMIN) {
            return false;
        }
        return config('ogp_title_admin_label', 'Admin Page');
    }

    /**
     * @return bool|string
     */
    protected function get404Title()
    {
        if (defined('ROOT_TPL_NAME') && ROOT_TPL_NAME === '404') {
            return config('ogp_title_404_label', '404 Not Found');
        }
        return false;
    }
}
