import React, { Component } from 'react';

export default class DatePicker extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    $(this.input).datepicker(Object.assign({}, ACMS.Config.dpicConfig, {
      onSelect: (date) => {
        if (this.props.onChange) {
          this.props.onChange(date);
        }
      }
    }));
    $(this.input).on('focus', () => {
      $(this.input).datepicker('widget').css('z-index', '1000');
    });
  }

  render() {
    return (<input type="text" value={this.props.value} className={this.props.className} style={this.props.style} onInput={this.props.onInput} ref={(ref) => { this.input = ref; }} />);
  }
}
