const webpack = require('webpack');
const path = require('path');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const ESLintPlugin = require('eslint-webpack-plugin');
const StylelintPlugin = require('stylelint-webpack-plugin');
const autoprefixer = require('autoprefixer');
const sass = require('sass');

module.exports = {
  cache: true,
  stats: {
    children: true,
  },
  resolve: {
    fallback: {
      'process/browser': require.resolve('process/browser'),
      stream: require.resolve('stream-browserify'),
    },
  },
  entry: {
    index: './ablogcms/js/src/entry/index.js',
    admin: './ablogcms/js/src/entry/admin.js',
  },
  output: {
    path: path.join(__dirname, 'ablogcms/'),
    publicPath: '',
    filename: 'js/dest/[name].js',
    chunkFilename: `js/dest/[name].chunk.js?date=${new Date().getTime()}`,
    assetModuleFilename: 'js/dest/assets/[name][ext]',
    uniqueName: 'acmsWebpackJsonp',
  },
  optimization: {
    splitChunks: {
      name: 'vendor',
      chunks: 'initial',
      cacheGroups: {
        vendorAdmin: {
          test: /styled-component|prop-types|react|react-dom/,
          name: 'vendor-admin',
          chunks: 'initial',
          enforce: true,
        },
      },
    },
  },
  module: {
    rules: [
      {
        test: /\.(js|ts|tsx)$/,
        include: [/js\/src/, /node_modules\/punycode/],
        use: {
          loader: 'babel-loader',
        },
      },
      {
        test: /\.(scss|css)$/,
        use: [
          {
            loader: MiniCssExtractPlugin.loader,
            options: {
              publicPath: '../../',
            },
          },
          {
            loader: 'css-loader',
            options: {
              url: true,
              // 0 => no loaders (default);
              // 1 => postcss-loader;
              // 2 => postcss-loader, sass-loader
              importLoaders: 2,
              sourceMap: true,
            },
          },
          {
            loader: 'postcss-loader',
            options: {
              postcssOptions: {
                plugins: [
                  autoprefixer({
                    grid: true,
                  })
                ],
              },
              sourceMap: true,
            },
          },
          {
            loader: 'sass-loader',
            options: {
              implementation: sass,
              sourceMap: true,
            },
          },
        ],
      },
      {
        test: /\.(jpg|png|svg|woff|woff2|eot|ttf)(\?.*$|$)/,
        type: 'asset',
        parser: {
          dataUrlCondition: {
            maxSize: 4 * 1024, // <--- 4kb
          },
        },
      },
    ],
  },
  plugins: [
    new ESLintPlugin({
      context: './ablogcms/js/src',
      extensions: ['js', 'ts', 'tsx', 'jsx'],
      exclude: ['/node_modules/'],
      emitError: true,
      emitWarning: true,
      failOnError: true,
      fix: true
    }),
    // new StylelintPlugin({
    //   configFile: '.stylelintrc',
    //   context: './ablogcms/js/src',
    //   emitError: true,
    //   emitWarning: true,
    //   failOnError: true,
    //   fix: true
    // }),
    new webpack.ProvidePlugin({
      process: 'process/browser',
      Buffer: ['buffer', 'Buffer'],
    }),
    new MiniCssExtractPlugin({
      filename: 'js/dest/[name].css',
      chunkFilename: `js/dest/[name].chunk.css?date=${new Date().getTime()}`,
    }),
  ],
};
