<?php

use Acms\Services\Facades\Storage;
use Acms\Services\Facades\Application;

class ACMS_GET_Admin_StaticExport extends ACMS_GET_Admin
{
    function get()
    {
        if (!sessionWithAdministration()) {
            die403();
        }
        $tpl = new Template($this->tpl, new ACMS_Corrector());
        $logger = Application::make('static-export.logger');

        /**
         * 書き出し中チェック
         */
        if ( Storage::exists($logger->getDestinationPath()) ) {
            $rootVars['processing'] = 1;
        } else {
            $rootVars['processing'] = 0;
            $rootVars['last-time-date'] = config('static-export-last-time-date', '1000-01-01');
            $rootVars['last-time-time'] = config('static-export-last-time-time', '00:00:00');
        }
        $tpl->add(null, $rootVars);

        return $tpl->get();
    }
}
