<?php

class ACMS_POST_Api_Twitter_OAuth_Login extends ACMS_POST
{
    public function post()
    {
        $type = $this->Post->get('type');
        $uid = null;
        if (empty($type)) {
            return false;
        }
        if ($type === 'addition') {
            $uid = UID;
        }
        /** @var Acms\Services\SocialLogin\Twitter $twitter */
        $twitter = App::make('twitter-login');
        $twitter->setLoginType($type, BID, $uid);

        [
            'request_token' => $requestToken,
            'request_token_secret' => $requestTokenSecret
        ] = $twitter->obtainRequestToken();

        $twitter->saveRequestTokens($requestToken, $requestTokenSecret);

        $this->redirect($twitter->getAuthenticateUrl($requestToken));
    }
}
