const { merge } = require('webpack-merge');
const { LicenseWebpackPlugin } = require('license-webpack-plugin');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const common = require('./webpack.common.js');

process.env.BABEL_ENV = 'production';

module.exports = merge(common, {
  mode: 'production',
  resolve: {
    extensions: ['.js', '.ts', '.tsx']
  },
  plugins: [
    new CopyWebpackPlugin({
      patterns: [
        {
          from: 'node_modules/pdfjs-dist/legacy/build/pdf.worker.min.mjs',
          to: 'js/dest/pdf.worker.js',
          force: true
        },
        {
          from: 'node_modules/pdfjs-dist/cmaps',
          to: 'js/dest/cmaps',
          force: true
        },
      ]
    }),
    new LicenseWebpackPlugin({
      outputFilename: 'js/3rdpartylicenses.txt',
      perChunkOutput: false, // combine all license information into one file
      unacceptableLicenseTest: (licenseType) => (licenseType === 'GPL'),
      handleUnacceptableLicense: (packageName, licenseType) => {
        throw new Error(`GPLライセンスが含まれています。 ${packageName}: ${licenseType}`);
      }
    })
  ]
});
