<?php

declare(strict_types=1);

namespace Acms\Services\Media\Constants;

/**
 * ファイル名検証エラーコード
 */
final class FileNameValidationError
{
    public const EMPTY = 'VALIDATE_FILENAME_EMPTY';
    public const NULL_BYTE = 'VALIDATE_FILENAME_NULL_BYTE';
    public const PATH_TRAVERSAL = 'VALIDATE_FILENAME_PATH_TRAVERSAL';
    public const LEADING_TRAILING_DOT = 'VALIDATE_FILENAME_LEADING_TRAILING_DOT';
    public const INVALID_CHARACTER = 'VALIDATE_FILENAME_INVALID_CHARACTER';
    public const INVALID_ENCODING = 'VALIDATE_FILENAME_INVALID_ENCODING';
    public const TOO_LONG = 'VALIDATE_FILENAME_TOO_LONG';
    public const WINDOWS_RESERVED = 'VALIDATE_FILENAME_WINDOWS_RESERVED';

    /**
     * インスタンス化を防ぐ
     */
    private function __construct()
    {
    }
}
