<?php

define('REQUEST_TIME', time());
define('START_TIME', microtime(true));

$script_dir = dirname(dirname($_SERVER['SCRIPT_FILENAME'])) . '/';
$script_name = dirname(dirname($_SERVER['SCRIPT_NAME'])) . 'index.php';
$script_file_name = $script_dir . 'index.php';

require_once $script_dir . 'php/vendor/autoload.php';

if (preg_match('@(.*?)([^/]+)$@', $_SERVER['SCRIPT_FILENAME'], $match)) {
    $scriptDir = $match[1];
    if (file_exists($scriptDir . '.env')) {
        Dotenv\Dotenv::createImmutable($scriptDir)->load();
    }
}
function env($key, $default = '')
{
    return isset($_ENV[$key]) ? $_ENV[$key] : $default;
}

/**
 * config.server.php
 */
if (!is_file($script_dir . 'config.server.php')) {
    die('config.server.php is missing');
}

require_once $script_dir . 'config.server.php';
require_once $script_dir . PHP_DIR . 'config/app.php';
require_once $script_dir . PHP_DIR . 'config/polyfill.php';

setPath($script_file_name, $script_name);

/**
 * autoload
 */
spl_autoload_register('autoload');

/**
 * Application env（Use of undefined constant対策）
 */
if (!defined('BID')) {
    define('BID', 1);
}
if (!defined('DATE')) {
    define('DATE', null);
}
if (!defined('IS_DEVELOPMENT')) {
    define('IS_DEVELOPMENT', null);
}
if (!defined('SEARCH_ENGINE_KEYWORD')) {
    define('SEARCH_ENGINE_KEYWORD', null);
}
if (!defined('SUID')) {
    define('SUID', null);
}
if (!defined('SBID')) {
    define('SBID', null);
}
if (!defined('EID')) {
    define('EID', null);
}
if (!defined('CID')) {
    define('CID', null);
}
if (!defined('UID')) {
    define('UID', null);
}
if (!defined('VIEW')) {
    define('VIEW', null);
}
if (!defined('AID')) {
    define('AID', null);
}
if (!defined('SESSION_NEXT_ID')) {
    define('SESSION_NEXT_ID', null);
}
if (!defined('RBID')) {
    define('RBID', null);
}
if (!defined('SESSION_USE_COOKIE')) {
    define('SESSION_USE_COOKIE', null);
}
if (!defined('TBID')) {
    define('TBID', null);
}
if (!defined('CMID')) {
    define('CMID', null);
}
if (!defined('UTID')) {
    define('UTID', null);
}
if (!defined('ACMS_SID')) {
    define('ACMS_SID', null);
}
if (!defined('RID')) {
    define('RID', null);
}
if (!defined('ADMIN')) {
    define('ADMIN', '');
}
if (!defined('ORDER')) {
    define('ORDER', '');
}
if (!defined('PAGE')) {
    define('PAGE', 1);
}
if (!defined('END')) {
    define('END', '');
}
if (!defined('START')) {
    define('START', '');
}
if (!defined('FIELD')) {
    define('FIELD', '');
}
if (!defined('TAG')) {
    define('TAG', '');
}
if (!defined('KEYWORD')) {
    define('KEYWORD', '');
}
if (!defined('RVID')) {
    define('RVID', null);
}
if (!defined('SYSTEM_GENERATED_DATETIME')) {
    define('SYSTEM_GENERATED_DATETIME', null);
}
if (!defined('IS_SETUP')) {
    define('IS_SETUP', true);
}

/**
 * application
 */
$config = appConfig();

$app = new Acms\Application();
$app->init($config['aliases'], $config['providers']);

/**
 * load license
 */
$app->loadLicense();
