import domContentLoaded from 'dom-content-loaded';
import topPage from './top';
import articlePage from './article';

/**
 * スタイルの読み込み
 */
import '../scss/site.scss';

topPage();
articlePage();

/**
 * Content Ready
 */
domContentLoaded(() => {
  // JSが有効か判断する
  $('html').removeClass('no-js').addClass('js');

  /**
   * 子要素に指定したセレクターの要素が存在するかを調べる
   */
  const has = (selector = '.js-has') => {
    const elements = document.querySelectorAll(selector);
    elements.forEach((element) => {
      const { target } = element.dataset;
      element.setAttribute('data-has', element.querySelector(`${selector} ${target}`) ? 'true' : 'false');
    });
  };

  has('.js-has');

  /**
   * 要素の表示/非表示
   */
  const fadeToggleButtons = document.querySelectorAll('.js-fadeToggle');
  fadeToggleButtons.forEach((button) => {
    button.addEventListener('click', (event) => {
      const self = event.currentTarget;
      const target = self.nextElementSibling;
      const icon = self.querySelectorAll('.icon-expand')[0];
      target.classList.toggle('is-active');
      icon.classList.toggle('is-close');
    });
  });

  /**
   * パスワードの確認ボタン
   */
  const togglePassword = document.getElementById('js-toggle-password');
  const inputOption = {
    password: {
      buttonText: 'パスワードを表示',
      buttonAria: 'パスワードをテキストで表示します。周りに人がいないことを確認して表示してください。',
    },
    text: {
      buttonText: 'パスワードを非表示',
      buttonAria: 'パスワードを非表示にします。',
    },
  };
  if (togglePassword !== null) {
    togglePassword.addEventListener('click', (event) => {
      const self = event.currentTarget;
      const targetSelector = self.dataset.target;
      const target = document.querySelector(targetSelector);

      if (target !== null) {
        if (target.type === 'password') {
          target.type = 'text';
          self.textContent = inputOption.text.buttonText;
          self.setAttribute('aria-label', inputOption.text.buttonAria);
        } else {
          target.type = 'password';
          self.textContent = inputOption.password.buttonText;
          self.setAttribute('aria-label', inputOption.password.buttonAria);
        }
      }
    });
  }
});
