<?php

declare(strict_types=1);

namespace Acms\Services\Media\Enums;

/**
 * ファイル名検証エラーコード
 */
enum FileNameValidationError: string
{
    case EMPTY = 'VALIDATE_FILENAME_EMPTY';
    case NULL_BYTE = 'VALIDATE_FILENAME_NULL_BYTE';
    case PATH_TRAVERSAL = 'VALIDATE_FILENAME_PATH_TRAVERSAL';
    case LEADING_TRAILING_DOT = 'VALIDATE_FILENAME_LEADING_TRAILING_DOT';
    case INVALID_CHARACTER = 'VALIDATE_FILENAME_INVALID_CHARACTER';
    case INVALID_ENCODING = 'VALIDATE_FILENAME_INVALID_ENCODING';
    case TOO_LONG = 'VALIDATE_FILENAME_TOO_LONG';
    case WINDOWS_RESERVED = 'VALIDATE_FILENAME_WINDOWS_RESERVED';
}
