# テーマ「member」2023/9/14 版

## テーマフォルダ直下のテンプレート

### 404.html

404 ページで表示されるテンプレートです。

### \_entry.html

詳細ページのテンプレートです。

### \_top.html

トップページのテンプレートです。

### admin.html

管理画面のテンプレートです。

### index.html

一覧ページのテンプレートです。

### search.html

キーワード検索時に使用されるテンプレートです。

### template.yaml

member テーマを選択したときに、テンプレートをまとめて設定できるファイルです。使用するかどうかは管理画面＞テーマ＞テーマ設定 にて変更できます。

## フォルダ構成

### admin

member テーマオリジナルの管理画面のテンプレートが入ったフォルダ。
member テーマでは主に以下のテンプレートが入っています。

- カスタムフィールド（ブログ・カテゴリー・エントリー・モジュール・ユーザー）
- ダッシュボード

### カテゴリーコード名フォルダ

a-blog cms で作ったカテゴリーと同じコード名でフォルダを作ると、その中にある index.html と\_entry.html はそのカテゴリーの専用テンプレートとなります。
member テーマでは以下のカテゴリー名フォルダを用意しています。

- article（記事）
- contact（お問い合わせ）
- download（ダウンロード）
- mypage（マイページ）
- special（特集）
- video（動画）
- members-only（会員限定記事）

### \_layouts

テンプレートの継承機能で使用するファイルが入ったフォルダです。
用途としては、主に別テンプレートでレイアウトを統一するために使います。

### dest

member テーマで使っている JS や CSS が入ったフォルダです。
src フォルダのファイルを結合したファイルです。

### images

member テーマで使っている画像が入ったフォルダです

### include

member テーマ内のインクルードしているテンプレートをまとめたフォルダです。

### src

member テーマで使用している結合前の js や scss ファイルを管理しているフォルダです。

## 利用している a-blog cms の基本機能

### 用意しているカスタムフィールド

#### ブログ

- サイトの設定
- SEO の設定
- OGP の設定
- 会社情報
- Search Console
- アクセス解析
- script 要素

#### カテゴリー

- SEO の設定
- OGP の設定
- ページタイトルの設定
- CTA の設定

#### エントリー

- SEO の設定
- ピックアップ の設定

#### モジュール

- CTA の設定（モジュール ID「MF_cta」）
- サイドカラム リンク集 の設定（モジュール ID「MF_side_links」）

#### ユーザー

- 会員プロフィール情報

#### フォーム
- 検索フォーム
- お問い合わせフォーム
- 新規会員登録フォーム
- 会員サインインフォーム
- 会員サインアップフォーム
- 退会フォーム
- プロフィール更新フォーム

#### エントリーの固定表示

エントリー編集ページの詳細設定の中にあるファイル名の入力欄を空にすると、エントリーが固定表示される機能。

- mypage（マイページ）

## 行っているカスタマイズについて

### 色について
/include/head/css-variables.css にて、各種色を変更できるようになっております。

### スライダーについて

お知らせのヘッドライン直下で使用しているスライダーは Splide という JavaScript プラグインを使用しています。使用方法に着いては Splide の公式サイトをご覧ください。

- Splide / https://ja.splidejs.com/

### ユニット

member テーマでは、独自で以下のユニットのスタイルを調整しています。

- ファイルユニット ... スタイル調整のため
- メディアユニット ... ファイルユニットに合わせたスタイル調整のため

### カスタムユニット

カスタムユニットを使い、ユニットの追加に「余白」「罫線」「価格表」「目次」のボタンを追加しています。

- /themes/member/include/unit/extend.html
- /themes/member/admin/entry/unit/extend.html

### グループユニット

ユニットグループは`.gu-`で始まるクラス名を適用しています。

SCSS をビルドせずに編集画面のスタイルをカスタマイズしたい場合は、以下のファイルをご利用ください。

- /themes/member/include/edit/custom.css
