<?php

class Export
{
    public $yaml;

    public function __construct($bid, $tables, $sep)
    {
        $DB = DB::singleton(dsn());

        foreach ($tables as $table) {
            $SQL = SQL::newSelect($table);
            $SQL->addWhereOpr($table . '_blog_id', $bid);
            $all = $DB->query($SQL->get(dsn()), 'all');

            if ($table === 'column') {
                $this->fixMarkdown($all);
                $this->fixHalfSpace($all, $sep);
            }
            if ($table === 'schedule') {
                $this->fixSchedule($all);
            }
            if ($table === 'fulltext') {
                $this->fixFulltext($all);
            }

            $this->setYaml($all, $table);
        }

        // blog config set
        $sql = SQL::newSelect('blog');
        $sql->addSelect('blog_config_set_id');
        $sql->addSelect('blog_config_set_scope');
        $sql->addSelect('blog_theme_set_id');
        $sql->addSelect('blog_theme_set_scope');
        $sql->addSelect('blog_editor_set_id');
        $sql->addSelect('blog_editor_set_scope');
        $sql->addWhereOpr('blog_id', $bid);
        $blog = DB::query($sql->get(dsn()), 'all');
        $this->setYaml($blog, 'blog');
    }

    public function setYaml($records, $table)
    {
        $this->yaml[$table] = $records;
    }

    public function getYaml()
    {
        return Config::yamlDump($this->yaml);
    }

    public function getArray()
    {
        return $this->yaml;
    }

    /**
     * escape single byte spaces of row's header
     *
     * @param $records
     * @param $sep
     */
    private function fixHalfSpace(&$records, $sep)
    {
        $cnt = count($records);

        for ($i = 0; $i < $cnt; $i++) {
            if ('text' === $records[$i]['column_type']) {
                $sep = empty($sep) ? '|s|' : $sep;
                $txt = $records[$i]['column_field_1'];
                $txt = preg_replace('/^([ ]+)/m', $sep . '$1', $txt);

                /*
                 * carrige returns \r and \r\n
                 * Paragraph Separator (U+2028)
                 * Line Separator (U+2029)
                 * Next Line (NEL) (U+0085)
                 */
                $records[$i]['column_field_1'] = preg_replace('/(\xe2\x80[\xa8-\xa9]|\xc2\x85|\r\n|\r)/', "\n", $txt);
            }
        }
    }

    /**
     * escape sharp(#) headlines of Markdown
     *
     * @param $records
     */
    private function fixMarkdown(&$records)
    {
        $cnt = count($records);

        for ($i = 0; $i < $cnt; $i++) {
            if (
                1
                && preg_match('@^(#*)(.*)$@', $records[$i]['column_field_1'])
                && 'text' === $records[$i]['column_type']
            ) {
                $records[$i]['column_field_1'] .= "\x0D\x0A";
            }
        }
    }

    /**
     * ignore user fulltext
     *
     * @param $records
     */
    private function fixFulltext(&$records)
    {
        $cnt = count($records);
        for ($i = 0; $i < $cnt; $i++) {
            if (!empty($records[$i]['fulltext_uid'])) {
                unset($records[$i]);
            }
        }
    }

    /**
     * ignore schedule data without base set
     *
     * @param $records
     */
    private function fixSchedule(&$records)
    {
        $cnt = count($records);

        for ($i = 0; $i < $cnt; $i++) {
            if (
                1
                && $records[$i]['schedule_year'] === 0000
                && $records[$i]['schedule_month'] === 00
            ) {
                // no touch
            } else {
                unset($records[$i]);
            }
        }
    }
}
