export function unique<T>(arr: T[]): T[] {
  return Array.from(new Set(arr));
}

export function arraysEqual<T>(a: T[], b: T[]): boolean {
  if (a.length !== b.length) {
    return false;
  }
  return a.every((val, index) => val === b[index]);
}
