const webpackMerge = require('webpack-merge');
const common = require('./webpack.common.js');

process.env.BABEL_ENV = 'development';

module.exports = webpackMerge.merge(common, {
  mode: 'development',
  devtool: 'inline-source-map',
  resolve: {
    modules: ['submodules', 'node_modules'],
    extensions: ['.js', '.ts', '.tsx'],
  },
  devServer: {
    open: true,
    openPage: '',
    inline: true,
    hot: false,
    // contentBase: `${__dirname}/dest`,
    publicPath: '/themes/system/dest/',
    watchContentBase: true,
    port: 3000,
    proxy: {
      '**': {
        target: {
          host: 'acms.org',
          protocol: 'http:',
          port: 80
        },
        secure: false,
        changeOrigin: true
      }
    }
  }
});
